unit yql;

{ By default http requests will be done with HTTPRequest in
  httprequests.pas which uses the Free Pascal library fphttpclient.

  If Ararat Synapse is preferred to fphttpclient, then define
  USE_HTTPREQUEST_1 below. The laz_synapse package  must be
  installed as well as the libssl-dev library. Furthermore the
  laz_synapse package must be added to the project's required
  packages. See httprequests_synapse.pas

  The sizes of the release version of the application are
    3 325 152 bytes with httprequests.pas and
    3 343 176 bytes with httprequests_synapse.pas

  For this application at least, I do not see any compelling
  reason to use Ararat Synapse.
  }

{ DEFINE USE_SYNAPSE}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, fpjson, jsonparser;


// if json = false: get result in XML
// if https = false: use http
function yqlUrl(const query: string; json: boolean = true;
                      https: boolean = true): string;

// if json = false: get result in XML
// if https = false: use http
function yqlRawData(const query: string; json: boolean = true;
                      https: boolean = true): string;

implementation

uses
  {$IFDEF USE_SYNAPSE}
  synacode, httprequests_synapse
  {$ELSE}
  fphttpclient, httprequests
  {$ENDIF}
  ;

const
  protocol : array[boolean] of string = ('http', 'https');
  yahooapis = 'query.yahooapis.com/v1/public/yql';

function yqlUrl(const query: string; json: boolean; https: boolean): string;
var
  outputformat: string;
begin
  if json then
    outputformat := '&format=json'
  else
    outputformat := '';
  result := Format('%s://%s?q=%s%s', [protocol[https], yahooapis, EncodeURLElement(query), outputformat]);
end;

function yqlRawData(const query: string; json: boolean; https: boolean): string;
var
  url: string;
  code: integer;
begin
  url := yqlUrl(query, json, https);
  HTTPRequest(url, code, result);
end;

end.




                                    +
