unit main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  StdCtrls, ComCtrls, Menus, fpjson, laz2_dom, laz2_xmlread, yql;

{ TForm1 }

type
  TForm1 = class(TForm)
    Label1: TLabel;
    MenuItem9: TMenuItem;
    UrlMenu: TPopupMenu;
    rawButton: TButton;
    Button2: TButton;
    ScrollBox1: TScrollBox;
    UrlButton: TButton;
    formattedButton: TButton;
    fview: TTreeView;
    Image1: TImage;
    Memo1: TMemo;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    MenuItem6: TMenuItem;
    MenuItem7: TMenuItem;
    MenuItem8: TMenuItem;
    Notebook1: TNotebook;
    Page1: TPage;
    Page2: TPage;
    MemoMenu: TPopupMenu;
    TreeMenu: TPopupMenu;
    RawFormatGroup: TRadioGroup;
    ProtocolGroup: TRadioGroup;
    yqlEdit: TLabeledEdit;
    procedure Button2Click(Sender: TObject);
    procedure formattedButtonClick(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure MenuItem1Click(Sender: TObject);
    procedure MenuItem2Click(Sender: TObject);
    procedure MenuItem3Click(Sender: TObject);
    procedure MenuItem4Click(Sender: TObject);
    procedure MenuItem6Click(Sender: TObject);
    procedure MenuItem8Click(Sender: TObject);
    procedure MenuItem9Click(Sender: TObject);
    procedure rawButtonClick(Sender: TObject);
    procedure ScrollBox1Click(Sender: TObject);
    procedure ScrollBox1DblClick(Sender: TObject);
    procedure UrlButtonClick(Sender: TObject);
  private
    { private declarations }
    procedure BuildUrl;
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  lclintf, clipbrd, structuredtotree;

{$R *.lfm}


{ TForm1 }

procedure TForm1.rawButtonClick(Sender: TObject);
begin
  BuildURL;
  memo1.lines.clear;
  memo1.lines.Add(yqlRawData(yqlEdit.text, RawFormatGroup.ItemIndex = 0,
    ProtocolGroup.ItemIndex = 0));
  Notebook1.PageIndex := 0;
end;

procedure TForm1.MenuItem4Click(Sender: TObject);
begin
  Clipboard.AsText := Memo1.Lines.Text;
end;


procedure TForm1.MenuItem6Click(Sender: TObject);
var
  stream: TStringStream;
begin
  stream := TStringStream.create;
  try
    fview.SaveToStream(stream);
    stream.position := 0;
    Clipboard.AsText := stream.UnicodeDataString;
  finally
    stream.free;
  end;
end;

procedure TForm1.MenuItem8Click(Sender: TObject);
begin
  BuildUrl;
  Clipboard.AsText := label1.caption;
end;

procedure fixjsonpath(var s: string);
var
  i: integer;
  ss: string;
begin
  i := 1;
  while i < length(s) do begin
    ss := copy(s, i, 2);
    if ss = ' :' then begin
      delete(s, i, maxint);
      break;
    end;
    if ss = '/[' then
      delete(s, i, 1);
    inc(i);
  end;
end;

procedure fixxmlpath(var s: string);
var
  i: integer;
begin
  for i := length(s) downto 1 do
    if s[i] = '/' then begin
      delete(s, i, maxint);
      exit;
    end;
end;


procedure TForm1.MenuItem9Click(Sender: TObject);
var
  s: string;
begin
  s := fview.Selected.GetTextPath;
  if s <> '' then begin
    if RawFormatGroup.ItemIndex = 0 then
      fixjsonpath(s)
    else if not fview.Selected.hasChildren then
      fixxmlpath(s);
    Clipboard.AsText := s;
    //ShowMessage(s);
    DefaultMessageBox(pchar(s), 'Path copied to clipboard', 0);
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  close
end;

procedure TForm1.ScrollBox1Click(Sender: TObject);
begin
  BuildURL;
end;

procedure TForm1.ScrollBox1DblClick(Sender: TObject);
begin
  BuildURL;
  Clipboard.AsText := label1.caption
end;

procedure TForm1.BuildUrl;
begin
  label1.Caption := trim(yqlUrl(yqlEdit.text, RawFormatGroup.ItemIndex = 0,
      ProtocolGroup.ItemIndex = 0));
end;

procedure TForm1.UrlButtonClick(Sender: TObject);
begin
  BuildUrl;
end;

procedure TForm1.formattedButtonClick(Sender: TObject);
var
  rdata: string;
  jdata: TJSONData;
  ss: TStringStream;
  xdata: TXMLDocument;
begin
  urlButtonClick(nil);

  rdata := yqlRawData(yqlEdit.text, RawFormatGroup.ItemIndex = 0,
             ProtocolGroup.ItemIndex = 0);
  Notebook1.PageIndex := 1;
  fview.items.clear;
  if RawFormatGroup.ItemIndex = 0 then begin
    jdata := GetJSON(rdata);
    try
      JSONDataToTree(jdata, fview);
    finally
      jdata.free;
    end;
  end
  else begin
    xdata := nil;
    ss := TStringStream.create(rdata);
    try
      ss.Position := 0;
      readXmlFile(xdata, ss);
      XMLDocumentToTree(xdata, fview);
    finally
      ss.free;
      xdata.free;
    end;
  end;
end;


(*   cheat to see how fpjson does it
procedure TForm1.formattedButtonClick(Sender: TObject);
var
  rdata: string;
  jdata: TJSONData;
begin
  urlButtonClick(nil);

  rdata := yqlRawData(yqlEdit.text, true, ProtocolGroup.ItemIndex = 0);
  Notebook1.PageIndex := 0;

  memo1.lines.clear;
  jdata := GetJSON(rdata);
  try
    memo1.lines.Text := jdata.FormatJSON;
  finally
    jdata.free;
  end;
end;
*)

procedure TForm1.Image1Click(Sender: TObject);
begin
   OpenURL('https://developer.yahoo.com/yql/guide/');
end;

procedure TForm1.MenuItem1Click(Sender: TObject);
begin
  MenuItem1.Checked := not MenuItem1.Checked;
  Memo1.WordWrap := MenuItem1.Checked;
  if Memo1.WordWrap then
    Memo1.ScrollBars := ssAutoVertical
  else
    Memo1.ScrollBars := ssAutoBoth;
end;

procedure TForm1.MenuItem2Click(Sender: TObject);
begin
  fview.FullExpand;
end;

procedure TForm1.MenuItem3Click(Sender: TObject);
begin
  fview.FullCollapse;
end;


end.

