unit metno;

{  Retrieve Meteorologisk Institutt (MET Norway - )
   current  weather conditions, weather forecasts and usage statistics
   as raw text (XML formatted) and as xxxx object. }

{ MET Normway Weather API v.3 reference :

    Introduction
       https://api.met.no/weatherapi/documentation

       https://api.met.no/weatherapi/weathericon/_/documentation/
}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, strutils, dateutils, math, fpjson, laz2_dom;

type
    { Application exceptions }
  TWeatherApiErr = class(Exception);

    { Weather elements that  can be requested from DarkSky
      with free account. }
  TRequestElement = (reWeather);     // daily forecast next 7 days

  TUnits = (uMetric);

  TDataFormat = (dfJSON, dfXML);
  TGetProtocol = (gpHTTPS, gpHTTP);

function LatLongLocation(latitude, longitude: double; altitude: double = NaN): string;

function WeatherUrl(q: TRequestElement;
                         const location: string;
                         const protocol: TGetProtocol = gpHTTPS;
                         const dataFormat: TDataFormat = dfXML;
                         const units: TUnits = uMetric;
                         const lang: string = ''): string;

implementation

uses
  metno_consts, httprequests;

const
  //apiUrl = 'https://api.met.no/weatherapi/locationforecast/1.9/?lat={lat}&lon={lon}'
  apiUrl = '%s://api.met.no/weatherapi/locationforecast/1.9/?%s';


function LatLongLocation(latitude, longitude: double; altitude: double): string;
var
  defaultDecimalSeparator: char;
begin
  defaultDecimalSeparator := DefaultFormatSettings.DecimalSeparator;
  DefaultFormatSettings.DecimalSeparator := '.';
  result := Format('lat=%.4f&lon=%.4f', [latitude, longitude]);
  if not isNan(altitude) then
    result := Format('%s&msl=%d', [result, round(altitude)]);
  DefaultFormatSettings.DecimalSeparator := defaultDecimalSeparator;
end;

function WeatherUrl(q: TRequestElement;
                         const location: string;
                         const protocol: TGetProtocol;
                         const dataFormat: TDataFormat;
                         const units: TUnits;
                         const lang: string): string;
const
  protocolstr: array[TGetProtocol] of string = ('https', 'http');

begin
  if location = '' then
    Raise TWeatherApiErr.create(SMissingLocation);
  result := Format(apiUrl, [protocolstr[protocol], location]);
end;


end.


