unit main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  StdCtrls, Menus, Buttons, ComCtrls, MaskEdit, fpjson, laz2_dom,
  metno, LocalizedForms;

{ TForm1 }

type
  TForm1 = class(TLocalizedForm)
    Button1: TButton;
    Button2: TButton;
    fview: TTreeView;
    Label2: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    LabeledEdit1: TLabeledEdit;
    latitudeEdit: TLabeledEdit;
    Memo1: TMemo;
    MemoMenu: TPopupMenu;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    MenuItem6: TMenuItem;
    MenuItem7: TMenuItem;
    MenuItem8: TMenuItem;
    MenuItem9: TMenuItem;
    Notebook1: TNotebook;
    Page1: TPage;
    Page2: TPage;
    RawButton: TButton;
    CloseButton: TButton;
    JsonButton: TButton;
    Label1: TLabel;
    longitudeEdit: TLabeledEdit;
    MenuItem1: TMenuItem;
    PageControl1: TPageControl;
    TreeMenu: TPopupMenu;
    URLMenu: TPopupMenu;
    ScrollBox1: TScrollBox;
    TabSheet1: TTabSheet;
    TabSheet3: TTabSheet;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure formattedButtonClick(Sender: TObject);
    procedure Label2Click(Sender: TObject);
    procedure cityCountryEditChange(Sender: TObject);
    procedure UrlLabelClick(Sender: TObject);
    procedure latitudeEditKeyPress(Sender: TObject; var Key: char);
    procedure MenuItem2Click(Sender: TObject);
    procedure MenuItem3Click(Sender: TObject);
    procedure MenuItem4Click(Sender: TObject);
    procedure MenuItem5Click(Sender: TObject);
    procedure MenuItem8Click(Sender: TObject);
    procedure MenuItem9Click(Sender: TObject);
    procedure RawButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Label1Click(Sender: TObject);
    procedure Label1DblClick(Sender: TObject);
    procedure MenuItem1Click(Sender: TObject);
  private
    { private declarations }
    procedure BuildURL;
    function GetCoord(const value: string; isLong: boolean): double;
  protected
    procedure UpdateTranslation(const ALang: String = ''); override;
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

uses
  LCLIntf, clipbrd, metno_consts, getweather, structuredtotree, strutils, aboutu;


{ TForm1 }

function TForm1.GetCoord(const value: string; isLong: boolean): double;
begin
  result := StrToFloat(value);
  if (isLong and (abs(result) > 180)) then
    Raise TWeatherApiErr.Create(SInvalidLongitude)
  else if ((not isLong) and (abs(result) > 90)) then
    Raise TWeatherApiErr.Create(SInvalidLatitude);
end;

procedure TForm1.BuildUrl;
var
  loc: string;
  p: integer;
begin
  if PageControl1.tabIndex = 0 then
    loc := latLongLocation(GetCoord(LatitudeEdit.text, false), GetCoord(LongitudeEdit.text, true))
  else
    exit;
  Label1.caption := WeatherUrl(reWeather,
    loc,
    gpHTTPS,
    dfXML,   //TDataFormat(RawFormatGroup.ItemIndex),
    TUnits(0),
    '');
end;

procedure TForm1.RawButtonClick(Sender: TObject);
var
  raw: string;
begin
  BuildUrl;
  memo1.lines.clear;
  invalidate;
  raw := '';
  WeatherRawData(label1.caption, raw);
  memo1.lines.text := raw;
  Notebook1.PageIndex := 0;
end;

procedure TForm1.formattedButtonClick(Sender: TObject);
var
  rawdata: string;
  xdata: TXMLDocument;
  pg: integer;
begin
  memo1.lines.clear;
  BuildUrl;
  invalidate;
  xdata := nil;
  rawdata := '';
  try
    if WeatherXMLData(label1.caption, rawdata, xdata) then begin
      XMLDocumentToTree(xdata, fview);
      pg := 1;
    end
    else begin
      Memo1.lines.Text := rawdata;
      pg := 0;
    end;
  finally
    xdata.free;
    Notebook1.PageIndex := pg;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  form3.showmodal;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  BuildUrl;
end;

procedure TForm1.latitudeEditKeyPress(Sender: TObject; var Key: char);
begin
   if Key = '.' then
     Key := DefaultFormatSettings.DecimalSeparator;
   if (Key >= ' ') then begin
     if not (Key in ['0'..'9', '-', DefaultFormatSettings.DecimalSeparator]) then
       Key := #0
   end;
end;

procedure TForm1.MenuItem2Click(Sender: TObject);
begin
  MenuItem2.Checked := not MenuItem2.Checked;
  Memo1.WordWrap := MenuItem1.Checked;
  if Memo1.WordWrap then
    Memo1.ScrollBars := ssAutoVertical
  else
    Memo1.ScrollBars := ssAutoBoth;
end;

procedure TForm1.MenuItem3Click(Sender: TObject);
begin
   fview.FullExpand;
end;

procedure TForm1.MenuItem4Click(Sender: TObject);
begin
   Clipboard.AsText := Memo1.Lines.Text;
end;

procedure TForm1.MenuItem5Click(Sender: TObject);
begin
   fview.FullCollapse;
end;

procedure TForm1.MenuItem8Click(Sender: TObject);
var
  stream: TStringStream;
begin
  stream := TStringStream.create;
  try
    fview.SaveToStream(stream);
    stream.position := 0;
    Clipboard.AsText := stream.UnicodeDataString;
  finally
    stream.free;
  end;
end;

procedure fixxmlpath(var s: string);
var
  i: integer;
begin
  for i := length(s) downto 1 do
    if s[i] = '/' then begin
      delete(s, i, maxint);
      exit;
    end;
end;


procedure TForm1.MenuItem9Click(Sender: TObject);
var
  s: string;
begin
  s := fview.Selected.GetTextPath;
  if s <> '' then begin
    if not fview.Selected.hasChildren then
      fixxmlpath(s);
    Clipboard.AsText := s;
    //ShowMessage(s);
    DefaultMessageBox(pchar(s), 'Path copied to clipboard', 0);
  end;
end;

procedure TForm1.Label2Click(Sender: TObject);
begin
  OpenURL('https://api.met.no/weatherapi/locationforecast/1.9/documentation');
end;

procedure TForm1.cityCountryEditChange(Sender: TObject);
begin

end;

procedure TForm1.UrlLabelClick(Sender: TObject);
begin
  OpenURL((Sender as TLabel).Caption);
end;


procedure TForm1.CloseButtonClick(Sender: TObject);
begin
  close
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  memo1.lines.clear;
  UpdateTranslation;
  constraints.minHeight := height;
  constraints.minWidth := width;
end;

procedure TForm1.Label1Click(Sender: TObject);
begin
  BuildURL;
end;

procedure TForm1.Label1DblClick(Sender: TObject);
begin
  clipboard.asText := label1.caption;
end;

procedure TForm1.MenuItem1Click(Sender: TObject);
begin
  BuildURL;
  Clipboard.AsText := label1.caption
end;

procedure TForm1.UpdateTranslation(const ALang: String);
begin
  inherited UpdateTranslation(ALang);
end;


end.

