unit structuredtotree;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, ComCtrls, fpjson, laz2_dom;

resourcestring
//  SArray   = 'Array (%d elements)';
//  SObject  = 'Object (%d members)';
  SNull    = 'null';

procedure JSONDataToTree(Data: TJSONData; tree: TTreeView);
procedure XMLDocumentToTree(XMLDoc: TXMLDocument; tree: TTreeView);

implementation


(*
// source: frmmain.pas in Lazarus jsonviewer tool (in lazarus/tools/jsonviewer)
procedure JSONDataToTree(Data : TJSONData; tree: TTreeView);
Const
  ImageTypeMap : Array[TJSONtype] of Integer =
//      jtUnknown, jtNumber, jtString, jtBoolean, jtNull, jtArray, jtObject
     (-1,8,9,7,6,5,4);

  procedure ProcessNode(Data: TJSONData; AParent: TTreeNode);
  Var
    N,N2 : TTreeNode;
    I : Integer;
    D : TJSONData;
    C : String;
    S : TStringList;

  begin
    if Not Assigned(Data) then
      exit;
    N:=tree.Items.AddChild(AParent,'');
    Case Data.JSONType of
      jtArray,
      jtObject:
        begin
          If (Data.JSONType=jtArray) then
            C:=SArray
          else
            C:=SObject;
          C:=Format(C,[Data.Count]);
          S:=TstringList.Create;
          try
            For I:=0 to Data.Count-1 do
              If Data.JSONtype=jtArray then
                S.AddObject(IntToStr(I),Data.items[i])
              else
                S.AddObject(TJSONObject(Data).Names[i],Data.items[i]);
            For I:=0 to S.Count-1 do  begin
              N2:=tree.Items.AddChild(N,S[i]);
              D:=TJSONData(S.Objects[i]);
              N2.ImageIndex:=ImageTypeMap[D.JSONType];
              N2.SelectedIndex:=ImageTypeMap[D.JSONType];
              ProcessNode(D, N2);
            end
          finally
            S.Free;
          end;
        end;
      jtNull:
        C:=SNull;
    else
      C:=Data.AsString;
      if (Data.JSONType=jtString) then
        C:='"'+C+'"';
    end;
    If Assigned(N) then begin
      If N.Text='' then
        N.Text:=C
      else
        N.Text:=N.Text+': '+C;
      N.ImageIndex:=ImageTypeMap[Data.JSONType];
      N.SelectedIndex:=ImageTypeMap[Data.JSONType];
      N.Data:=Data;
    end;
  end;

begin
  ProcessNode(Data, nil);
end;
*)

function JSONFloatToString(Data: TJSONData): string;
var
  defaultDecimalSeparator: char;
begin
  defaultDecimalSeparator := DefaultFormatSettings.DecimalSeparator;
  DefaultFormatSettings.DecimalSeparator := '.';
  result := Format('%.8g', [Data.AsFloat]);
  DefaultFormatSettings.DecimalSeparator := defaultDecimalSeparator;
end;

procedure JSONDataToTree(Data : TJSONData; tree: TTreeView);
Const
  ImageTypeMap : Array[TJSONtype] of Integer =
//      jtUnknown, jtNumber, jtString, jtBoolean, jtNull, jtArray, jtObject
     (-1,8,9,7,6,5,4);

  procedure ProcessNode(Data: TJSONData; TreeNode: TTreeNode);
  Var
    ParentNode,N2 : TTreeNode;
    I : Integer;
    D : TJSONData;
    NodeValue : String;

  begin
    if Not Assigned(Data) then
      exit;
    //ParentNode := tree.Items.AddChild(TreeNode,'');
    ParentNode := TreeNode;

    Case Data.JSONType of

      jtArray:
        for i := 0 to Data.Count-1 do begin
          N2 := tree.Items.AddChild(ParentNode, Format('[%d]', [i]));
          D := Data.Items[i];
          N2.ImageIndex := ImageTypeMap[D.JSONType];
          N2.SelectedIndex := ImageTypeMap[D.JSONType];
          ProcessNode(D, N2);
        end;

      jtObject:
        for i := 0 to Data.Count-1 do begin
          N2 := tree.Items.AddChild(ParentNode, TJSONObject(Data).Names[i]);
          D := TJSONData(Data.items[i]);
          N2.ImageIndex:=ImageTypeMap[D.JSONType];
          N2.SelectedIndex:=ImageTypeMap[D.JSONType];
          ProcessNode(D, N2);
        end;

      jtNull:
        NodeValue := SNull;

      else begin
        if Data.JSONType = jtString then
          NodeValue := '"' + Data.AsString + '"'
        else if (Data.JSONType = jtNumber)
        and (TJsonNumber(data).NumberType = ntFloat) then begin
          NodeValue := JSONFloatToString(Data)
        end
        else
          NodeValue := Data.AsString;
      end;
    end;

    If Assigned(ParentNode) then begin
      If ParentNode.Text = '' then
        ParentNode.Text :=  NodeValue
      else if NodeValue <> '' then
        ParentNode.Text := Format('%s : %s', [ParentNode.Text, NodeValue]);
      ParentNode.ImageIndex:=ImageTypeMap[Data.JSONType];
      ParentNode.SelectedIndex:=ImageTypeMap[Data.JSONType];
    end;
  end;

begin
  Tree.Items.Clear;
  ProcessNode(Data, nil);
end;

{$DEFINE ATTRIBUTES_NODE_TREE}
{ DEFINE ATTRIBUTES_NODE_FLAT}
{ DEFINE ATTRIBUTES_WITH_NODE_NAME}


// source: http://wiki.lazarus.freepascal.org/XML_Tutorial#Populating_a_TreeView_with_XML
// modified but I have no idea what I am doing
procedure XMLDocumentToTree(XMLDoc: TXMLDocument; tree: TTreeView);
var
  iNode: TDOMNode;

  procedure ProcessNode(Node: TDOMNode; TreeNode: TTreeNode);
  var
    currentDOMNode: TDOMNode;
    {$IFDEF ATTRIBUTES_NODE_TREE}
    attrNode: TTreeNode;
    {$ENDIF}
    s, attr: string;
    j: integer;

  begin
    if Node = nil then Exit; // Stops if reached a leaf

    {$IFDEF ATTRIBUTES_WITH_NODE_NAME}
    attr := '';
    if Node.HasAttributes and (Node.Attributes.Length>0) then begin
      attr := '<attributes>';
      for j := 0 to Node.Attributes.Length-1 do
        attr := attr + Format(' %s:"%s"', [Node.Attributes[j].NodeName, Node.Attributes[j].NodeValue]);
    end;
    {$ENDIF}

    // Adds a node to the tree
    s := Node.NodeName;
    if (s <> '') and (s[1] = '#') then
      s := Node.NodeValue
    {$IFDEF ATTRIBUTES_WITH_NODE_NAME}
    else
      s := s + ' ' + attr
    {$ENDIF};
    TreeNode := tree.Items.AddChild(TreeNode, s);

    {$IFnDEF ATTRIBUTES_WITH_NODE_NAME}
    if Node.HasAttributes and (Node.Attributes.Length>0) then begin
      {$IFDEF ATTRIBUTES_NODE_FLAT}
      attr := '<attributes>';
      for j := 0 to Node.Attributes.Length-1 do
        attr := attr + Format(' %s:"%s"', [Node.Attributes[j].NodeName, Node.Attributes[j].NodeValue]);
      if attr <> '' then
        tree.items.AddChild(TreeNode, attr);
      {$ELSE}  // ATTRIBUTES_NODE_TREE
      attrNode := tree.Items.AddChild(TreeNode, '< attributes >');
      for j := 0 to Node.Attributes.Length-1 do
         tree.Items.AddChild(attrNode, Format(' %s:"%s"', [Node.Attributes[j].NodeName, Node.Attributes[j].NodeValue]));
       {$ENDIF}
    end;
    {$ENDIF}

    // Goes to the child node
    currentDOMNode := Node.FirstChild;

    // Processes all child nodes
    while currentDOMNode <> nil do begin
      ProcessNode(currentDOMNode, TreeNode);
      currentDOMNode := currentDOMNode.NextSibling;
    end;
  end;

begin
  Tree.Items.Clear;
  iNode := XMLDoc.DocumentElement.FirstChild;
  while iNode <> nil do begin
    ProcessNode(iNode, nil); // Recursive
    iNode := iNode.NextSibling;
  end;
end;

end.

