unit pwd;

{$mode objfpc}{$H+}

interface

// Define MORE_SECURE to query for the passphrase at startup
{-$DEFINE MORE_SECURE}

uses
  Classes, SysUtils, Dialogs;

procedure SetKey(const value: string);
function GetKey: string;

resourcestring
  SNoKeyDefined = 'The weather API key is not defined';
  SInvalidApiKey = 'Decryption error, invalid API key';
  SPassTitle = 'Passphrase';
  SEnterPass = 'Enter passphrase';

  {$IFnDEF MORE_SECURE}
  SChangePassphrase =       'The passphrase to secure the API key should' +
                      #13#10'not be set in code and should be queried.' +
                #13#10#13#10'Define the directive MORE_SECURE in pwd.pas' +
                      #13#10'or, at the very least, change the default' +
                      #13#10'passphrase in the same file.';

  {$ENDIF}

implementation

uses
  DCPsha1, DCPtwofish;

const
  SALT = '<default"salt.>';  // change this for added security

var
  Passphrase: string;
  path: string;

function encrypt(const value: string): string;
var
  Cipher: TDCP_twofish;
begin
 Cipher := TDCP_twofish.Create(nil);
 Cipher.InitStr(Passphrase, TDCP_sha1);      // initialize the cipher with a hash of the passphrase
 result := Cipher.EncryptString(SALT+value); // encrypt the contents of the memo
 Cipher.Burn;
 Cipher.Free;
end;

function decrypt(const value: string): string;
var
  Cipher: TDCP_twofish;
begin
 Cipher := TDCP_twofish.Create(nil);
 Cipher.InitStr(Passphrase, TDCP_sha1); // initialize the cipher with a hash of the passphrase
 result := Cipher.DecryptString(value); // encrypt the contents of the memo
 Cipher.Burn;
 Cipher.Free;
 if copy(result, 1, length(SALT)) <> SALT then
   Raise Exception.create(SInvalidAPIKey);
 delete(result, 1, length(SALT));
end;

procedure SetKey(const value: string);
var
  f: textfile;
begin
  assignfile(f, path);
  rewrite(f);
  writeln(f, encrypt(value));
  closefile(f);
end;

function GetKey: string;
var
  f: textfile;

begin
  assignfile(f, path);
  try
    reset(f);
    readln(f, result);
    result := decrypt(result);
  finally
    closefile(f);
  end;
end;

procedure setup;
begin
  passphrase := '';
  {$IFDEF MORE_SECURE}
  InputQuery(SPassTitle,SEnterPass,passphrase);
  {$ELSE}
  passphrase := '<default!pass.phrase>';
  {$ENDIF}
  path := extractfilepath(paramstr(0)) +'key.txt';
  if not fileexists(path) then
    ShowMessage(SNoKeyDefined);
  {$IFnDEF MORE_SECURE}
  ShowMessage(SChangePassphrase);
  {$ENDIF}
end;

initialization
  setup;
end.

