{ Version 1 - uses laz_synapse }

unit httprequests_synapse;

{$mode objfpc}{$H+}

{
 Uses:

     Ararat Synapse (40.1) obtained by downloading the snapshot at
         https://sourceforge.net/p/synalist/code/HEAD/tree/trunk/.

     openssl must be installed as well as the libssl-dev library to
     use HTTPS to access the Weatherbit.io APIs.

     On Ubuntu 17.0 & 18.04 openssl is preinstalled as can be verified

        michel@hp:~$ apt-cache policy openssl

     and

        michel@hp:~$ sudo apt install libssl-dev

     takes care of installing the ssl development package.

     Also needed is the ssl_openssl.pas unit from Synapse. Although that
     file is included in the source directory of synapse, it is not
     part of the synapse package. So it will be necessary to include
     it in the project. Load the file in an IDE editor window and
     click on Add the editor file to the project in the Project menu.
}

interface

uses
  Classes, SysUtils, httpsend;

function SingleHTTPRequest(const aURL: string;
                    out code: integer; out rawdata: string): boolean;

function HTTPRequest(const aURL: string;
                    out code: integer; out rawdata: string;
                    maxtries: integer = 3): boolean;

resourcestring
  SServerError = 'Server error code: %d'#10'%s';

implementation

function SingleHTTPRequest(const aURL: string; out code: integer; out rawdata: string): boolean;
begin
 rawdata := '';
 code := 0;
 with THTTPSend.Create do
   try
     KeepAlive := false;
     result := HTTPMethod('GET', aURL);
     code := ResultCode;
     if result and (code >= 100) and (code < 400) then
       SetString(rawdata, PAnsiChar(Document.Memory), Document.Size)
     else
       rawdata := Format(SServerError, [ResultCode, ResultString]);
   finally
     Free;
   end;
end;

function HTTPRequest(const aURL: string;
                    out code: integer; out rawdata: string;
                    maxtries: integer = 3): boolean;
var
 i: integer;
begin
 if maxtries < 1 then
   maxtries := 1;
 for i := 0 to maxtries-1 do begin
   sleep(i*500);
   result := SingleHTTPRequest(aURL, code, rawdata);
   if result then
     exit;
 end;
end;

end.

