{ Version 2 - uses fphttpclient }

unit httprequests;

{$mode objfpc}{$H+}

{
Uses:

   The fphttpclient package for http/https requests.

   It is not clear to me if the openssl library needs
   to be installed (it was needed when using Synapse)
   because on Ubuntu 17.0 & 18.04 openssl is
   preinstalled as can be verified

      michel@hp:~$ apt-cache policy openssl

   Synapse also needed to the libssl-dev library.
   It was not installed on Ubuntu 17.0 & 18.04 but
   it is not needed by fhhttpclient. }

interface

uses
  fphttpclient, SysUtils;

function SingleHTTPRequest(const aURL: string;
                    out code: integer; out rawdata: string): boolean;

function HTTPRequest(const aURL: string;
                    out code: integer; out rawdata: string;
                    maxtries: integer = 3): boolean;

resourcestring
  SServerError = 'Server error code: %d'#10'%s';
  SNoDataError = 'No data retreived from server';

implementation

function SingleHTTPRequest(const aURL: string; out code: integer; out rawdata: string): boolean;
begin
 rawdata := '';
 code := 0;
 with TFPHTTPClient.create(nil) do
   try
     try
       KeepConnection := False;
       rawdata := Get(aURL);
       if rawdata = '' then begin
         result := false;
         rawdata := SNoDataError;
       end;
     except
       rawdata := Format(SServerError, [ResponseStatusCode, ResponseStatusText]);
       result := false;
     end;
   finally
     code := ResponseStatusCode;
     Free;
   end;
end;

function HTTPRequest(const aURL: string;
                    out code: integer; out rawdata: string;
                    maxtries: integer = 3): boolean;
var
 i: integer;
begin
 if maxtries < 1 then
   maxtries := 1;
 for i := 0 to maxtries-1 do begin
   sleep(i*500);
   result := SingleHTTPRequest(aURL, code, rawdata);
   if result then
     exit;
 end;
end;

end.

