unit aboutu;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls, Buttons,
  ExtCtrls, ComCtrls, LocalizedForms;

type

  { TForm3 }

  TForm3 = class(TLocalizedForm)
    Button1: TButton;
    Image1: TImage;
    Label1: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Memo1: TMemo;
    PageControl1: TPageControl;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    Shape1: TShape;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Label1Click(Sender: TObject);
    procedure RadioButton1Change(Sender: TObject);
  private

  protected
    procedure UpdateTranslation(const ALang: String = ''); override;
  public

  end;

var
  Form3: TForm3;

implementation

{$R *.lfm}

uses
  main, LCLIntf;

resourcestring

SLicense =
  'This program is a part of an investigation of free weather API.' +
  #10'It is open source and can be found following the link below.' +
  #10#10'License' +
  #10#10'Copyright (c) 2018, Michel Deslierres. All rights reserved.' +
  #10#10'Redistribution and use in source and binary forms, with or without modification,' +
  #10'are permitted provided that the following conditions are met:' +
  #10#10'1. Redistributions of source code must retain the above copyright notice, this' +
  #10'   list of conditions and the following disclaimer.' +
  #10#10'2. Redistributions in binary form must reproduce the above copyright notice,' +
  #10'   this list of conditions and the following disclaimer in the documentation' +
  #10'   and/or other materials provided with the distribution.' +
  #10#10'THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER "AS IS" AND ANY EXPRESS OR' +
  #10'IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF' +
  #10'MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT' +
  #10'SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,' +
  #10'SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,' +
  #10'PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR' +
  #10'BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN' +
  #10'CONTRACT,STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING' +
  #10'IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY' +
  #10'OF SUCH DAMAGE.';

{ TForm3 }


procedure TForm3.FormCreate(Sender: TObject);
begin
  UpdateTranslation;
end;

procedure TForm3.Label1Click(Sender: TObject);
begin
  OpenURL(label1.caption);
end;

procedure TForm3.RadioButton1Change(Sender: TObject);
begin
   if radiobutton1.checked then begin
    if CurrentLanguage <> 'en' then
      SelectLanguage('en')
  end
  else if radiobutton2.checked then begin
    if CurrentLanguage <> 'fr' then
      SelectLanguage('fr');
  end;
end;

procedure TForm3.UpdateTranslation(const ALang: String);
begin
  inherited UpdateTranslation(ALang);
  if copy(CurrentLanguage, 1, 2) = 'fr' then
    RadioButton2.checked := true
  else
    RadioButton1.checked := true;
  Memo1.Lines.Text := SLicense;
end;

procedure TForm3.Button1Click(Sender: TObject);
begin
  close
end;

end.

