unit main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  StdCtrls, Menus, Buttons, ComCtrls, MaskEdit, fpjson, laz2_dom,
  apixu, LocalizedForms;

{ TForm1 }

type
  TForm1 = class(TLocalizedForm)
    Button1: TButton;
    Button2: TButton;
    AirportEdit: TEdit;
    fview: TTreeView;
    IpEdit: TEdit;
    keyEdit: TLabeledEdit;
    cityCountryEdit: TLabeledEdit;
    Label2: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label9: TLabel;
    latitudeEdit: TLabeledEdit;
    Memo1: TMemo;
    MemoMenu: TPopupMenu;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    MenuItem6: TMenuItem;
    MenuItem7: TMenuItem;
    MenuItem8: TMenuItem;
    MenuItem9: TMenuItem;
    Notebook1: TNotebook;
    Page1: TPage;
    Page2: TPage;
    ProtocolGroup: TRadioGroup;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton4: TRadioButton;
    RawButton: TButton;
    CloseButton: TButton;
    JsonButton: TButton;
    cbxLang: TComboBox;
    cbxFetch: TComboBox;
    cbxUnits: TComboBox;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    cityNameEdit: TLabeledEdit;
    Label5: TLabel;
    postalCodeEdit: TLabeledEdit;
    postalCountryEdit: TLabeledEdit;
    longitudeEdit: TLabeledEdit;
    MenuItem1: TMenuItem;
    PageControl1: TPageControl;
    rbIATA: TRadioButton;
    SetKeyButton: TButton;
    SpeedButton1: TSpeedButton;
    TreeMenu: TPopupMenu;
    URLMenu: TPopupMenu;
    RawFormatGroup: TRadioGroup;
    ScrollBox1: TScrollBox;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    TabSheet6: TTabSheet;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure formattedButtonClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Label2Click(Sender: TObject);
    procedure UrlLabelClick(Sender: TObject);
    procedure latitudeEditKeyPress(Sender: TObject; var Key: char);
    procedure MenuItem2Click(Sender: TObject);
    procedure MenuItem3Click(Sender: TObject);
    procedure MenuItem4Click(Sender: TObject);
    procedure MenuItem5Click(Sender: TObject);
    procedure MenuItem8Click(Sender: TObject);
    procedure MenuItem9Click(Sender: TObject);
    procedure RawButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Label1Click(Sender: TObject);
    procedure Label1DblClick(Sender: TObject);
    procedure MenuItem1Click(Sender: TObject);
    procedure SetKeyButtonClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { private declarations }
    procedure BuildURL;
    function GetCoord(const value: string; isLong: boolean): double;
  protected
    procedure UpdateTranslation(const ALang: String = ''); override;
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

uses
  LCLIntf, clipbrd, apixu_consts, pwd, getweather, structuredtotree, strutils, aboutu;

{ TForm1 }

function TForm1.GetCoord(const value: string; isLong: boolean): double;
begin
  result := StrToFloat(value);
  if (isLong and (abs(result) > 180)) then
    Raise TWeatherApiErr.Create(SInvalidLongitude)
  else if ((not isLong) and (abs(result) > 90)) then
    Raise TWeatherApiErr.Create(SInvalidLatitude);
end;

procedure TForm1.BuildUrl;
var
  loc: string;
  lan: string;
  p: integer;

  function AC: TAirportCode;
  begin
    if rbIATA.checked then
      result := acIATA
    else
      result := acICAO;
  end;

begin
  case PageControl1.tabIndex of
     0: loc := cityByNameLocation(cityNameEdit.text, cityCountryEdit.Text);
     1: loc := postalCodeLocation(postalCodeEdit.text);//, postalCountryEdit.text);
     2: loc := latLongLocation(GetCoord(LatitudeEdit.text, false), GetCoord(LongitudeEdit.text, true));
     3: loc := AirportIdLocation(AirportEdit.Text, AC);
     4: loc := IpLocation(RadioButton2.checked,IpEdit.Text);
     else abort;   // in key page!
  end;
  lan := cbxLang.text;
  p := pos(' -', lan);
  delete(lan, p, maxint);
  if lan = 'en' then
    lan := '';
  Label1.caption := WeatherUrl(TRequestElement(cbxFetch.ItemIndex),
    loc,
    TGetProtocol(ProtocolGroup.ItemIndex),
    TDataFormat(RawFormatGroup.ItemIndex),
    TUnits(cbxUnits.ItemIndex),
    lan);
end;

procedure TForm1.RawButtonClick(Sender: TObject);
var
  fkey, raw: string;
begin
  BuildUrl;
  memo1.lines.clear;
  invalidate;
  raw := '';
  fkey := getKey;
  WeatherRawData(AnsiReplaceStr(label1.caption, '{key}', fkey), raw);
  fillchar(fkey[1], length(fkey), #0);
  memo1.lines.text := raw;
  Notebook1.PageIndex := 0;
end;

procedure TForm1.formattedButtonClick(Sender: TObject);
var
  fkey, rawdata: string;
  jdata: TJSONData;
  xdata: TXMLDocument;
  pg: integer;
  res: boolean;
begin
  memo1.lines.clear;
  BuildUrl;
  invalidate;
  jdata := nil;
  rawdata := '';
  fkey := getKey;
  if RawFormatGroup.ItemIndex = 0 then try
    res := WeatherJSONData(AnsiReplaceStr(label1.caption, '{key}', fkey), rawdata, jdata);
    fillchar(fkey[1], length(fkey), #0);
    if res then begin
      JSONDataToTree(jdata, fview);
      pg := 1;
    end
    else begin
      Memo1.lines.Text := rawdata;
      pg := 0;
    end
  finally
    jdata.free;
    Notebook1.PageIndex := pg;
  end
  else if RawFormatGroup.ItemIndex = 1 then try
    res := WeatherXMLData(AnsiReplaceStr(label1.caption, '{key}', fkey), rawdata, xdata);
    fillchar(fkey[1], length(fkey), #0);
    if res then begin
      XMLDocumentToTree(xdata, fview);
      pg := 1;
    end
    else begin
      Memo1.lines.Text := rawdata;
      pg := 0;
    end;
  finally
    xdata.free;
    Notebook1.PageIndex := pg;
  end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  cbxUnits.Enabled := false;
  label5.Enabled := false;
  postalCountryEdit.Enabled := false;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  form3.showmodal;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  BuildUrl;
end;

procedure TForm1.latitudeEditKeyPress(Sender: TObject; var Key: char);
begin
   if Key = '.' then
     Key := DefaultFormatSettings.DecimalSeparator;
   if (Key >= ' ') then begin
     if not (Key in ['0'..'9', '-', DefaultFormatSettings.DecimalSeparator]) then
       Key := #0
   end;
end;

procedure TForm1.MenuItem2Click(Sender: TObject);
begin
  MenuItem2.Checked := not MenuItem2.Checked;
  Memo1.WordWrap := MenuItem1.Checked;
  if Memo1.WordWrap then
    Memo1.ScrollBars := ssAutoVertical
  else
    Memo1.ScrollBars := ssAutoBoth;
end;

procedure TForm1.MenuItem3Click(Sender: TObject);
begin
   fview.FullExpand;
end;

procedure TForm1.MenuItem4Click(Sender: TObject);
begin
   Clipboard.AsText := Memo1.Lines.Text;
end;

procedure TForm1.MenuItem5Click(Sender: TObject);
begin
   fview.FullCollapse;
end;

procedure TForm1.MenuItem8Click(Sender: TObject);
var
  stream: TStringStream;
begin
  stream := TStringStream.create;
  try
    fview.SaveToStream(stream);
    stream.position := 0;
    Clipboard.AsText := stream.UnicodeDataString;
  finally
    stream.free;
  end;
end;

procedure fixjsonpath(var s: string);
var
  i: integer;
  ss: string;
begin
  i := 1;
  while i < length(s) do begin
    ss := copy(s, i, 2);
    if ss = ' :' then begin
      delete(s, i, maxint);
      break;
    end;
    if ss = '/[' then
      delete(s, i, 1);
    inc(i);
  end;
  for i := 1 to length(s) do
    if s[i] = '/' then
      s[i] := '.';
  s := #39 + s + #39;
end;

procedure fixxmlpath(var s: string);
var
  i: integer;
begin
  for i := length(s) downto 1 do
    if s[i] = '/' then begin
      delete(s, i, maxint);
      exit;
    end;
end;


procedure TForm1.MenuItem9Click(Sender: TObject);
var
  s: string;
begin
  s := fview.Selected.GetTextPath;
  if s <> '' then begin
    if RawFormatGroup.ItemIndex = 0 then
      fixjsonpath(s)
    else if not fview.Selected.hasChildren then
      fixxmlpath(s);
    Clipboard.AsText := s;
    //ShowMessage(s);
    DefaultMessageBox(pchar(s), 'Path copied to clipboard', 0);
  end;
end;

procedure TForm1.Label2Click(Sender: TObject);
begin
  OpenURL('https://apixu.com');
end;


procedure TForm1.UrlLabelClick(Sender: TObject);
begin
  OpenURL((Sender as TLabel).Caption);
end;


procedure TForm1.CloseButtonClick(Sender: TObject);
begin
  close
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  memo1.lines.clear;
  UpdateTranslation;
  constraints.minHeight := height;
  constraints.minWidth := width;
end;

procedure TForm1.Label1Click(Sender: TObject);
begin
  BuildURL;
end;

procedure TForm1.Label1DblClick(Sender: TObject);
begin
  clipboard.asText := label1.caption;
end;

procedure TForm1.MenuItem1Click(Sender: TObject);
begin
  BuildURL;
  Clipboard.AsText := label1.caption
end;

procedure TForm1.SetKeyButtonClick(Sender: TObject);
begin
  SetKey(trim(KeyEdit.text));
  KeyEdit.text := '';
  SpeedButton1.Down := false;
  keyEdit.PasswordChar := '*';
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  if SpeedButton1.Down then begin
    keyEdit.PasswordChar := #0
  end
  else begin
    keyEdit.PasswordChar := '*';
  end;
end;

procedure TForm1.UpdateTranslation(const ALang: String);
var
  i, j: integer;
begin
  inherited UpdateTranslation(ALang);
  i := cbxFetch.ItemIndex;
  with cbxFetch.Items do begin
    clear;
    add(SCurrentConditions);
    add(SForecast);
  end;
  if i < 0 then i := 0;
  cbxFetch.ItemIndex := i;

  i := cbxUnits.ItemIndex;
  with cbxUnits.Items do begin
    clear;
    add(SImperial);
    add(SMetric);
  end;
  if i < 0 then i := 1;
  cbxUnits.ItemIndex := i;

  with cbxLang.Items do begin
    clear;
    add(S_da);
    add(S_de);
    add(S_el);
    add(S_en);
    add(S_es);
    add(S_fi);
    add(S_fr);
    add(S_hi);
    add(S_hu);
    add(S_it);
    add(S_ja);
    add(S_jv);
    add(S_ko);
    add(S_mr);
    add(S_nl);
    add(S_pa);
    add(S_pl);
    add(S_pt);
    add(S_ro);
    add(S_ru);
    add(S_si);
    add(S_sk);
    add(S_sr);
    add(S_sv);
    add(S_ta);
    add(S_te);
    add(S_tr);
    add(S_uk);
    add(S_ur);
    add(S_vi);
    add(S_zh);
    add(S_zh_cmn);
    add(S_zh_hsn);
    add(S_zh_tw);
    add(S_zh_wuu);
    add(S_zh_yue);
    add(S_zu);
  end;
  cbxLang.Sorted := true;
  cbxLang.Sorted := false;

  j := -1;
  for i := 0 to cbxLang.Items.count-1 do
    if copy(cbxLang.Items[i], 1, length( CurrentLanguage)) = CurrentLanguage then begin
      j := i;
      break;
    end;
  if j < 0 then begin
    j := cbxLang.Items.IndexOf(S_en);
    if j < 0 then
      j := 0;
  end;
  cbxLang.ItemIndex := j;
end;


end.

