unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    CheckBox1: TCheckBox;
    PlayButton: TButton;
    QuitButton: TButton;
    StopButton: TButton;
    WavEdit: TEdit;
    procedure PlayButtonClick(Sender: TObject);
    procedure QuitButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
  private
    procedure buttonsEnabled(value: boolean);
    procedure EnableButtons(sender: TObject);
  public

  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

uses
    playunit;

{ TForm1 }

procedure TForm1.PlayButtonClick(Sender: TObject);
begin
  buttonsEnabled(false);
  play(WavEdit.Text, @EnableButtons, checkbox1.checked);
end;

procedure TForm1.QuitButtonClick(Sender: TObject);
begin
  close;
end;

procedure TForm1.StopButtonClick(Sender: TObject);
begin
  StopPlaying;
end;

procedure TForm1.buttonsEnabled(value: boolean);
begin
  PlayButton.enabled := value;
  StopButton.Enabled := not value;
end;

procedure TForm1.EnableButtons(sender: TObject);
begin
  buttonsEnabled(true);
end;

end.

