unit main;

{$mode delphi}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Spin;

{ TForm1 }

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    cbDigitType: TComboBox;
    DecimalsSpin: TSpinEdit;
    Edit1: TEdit;
    Label1: TLabel;
    Label3: TLabel;
    Measure_1: TComboBox;
    ConvType_1: TComboBox;
    Measure_2: TComboBox;
    ConvType_2: TComboBox;
    Edit2: TEdit;
    Measure_3: TComboBox;
    ConvType_3: TComboBox;
    Measure_4: TComboBox;
    ConvType_4: TComboBox;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ConvType_1Change(Sender: TObject);
    procedure ConvType_3Change(Sender: TObject);
    procedure Edit1EditingDone(Sender: TObject);
    procedure Edit2EditingDone(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Measure_1Change(Sender: TObject);
    procedure Measure_2Change(Sender: TObject);
    procedure Measure_3Change(Sender: TObject);
    procedure Measure_4Change(Sender: TObject);
  private
    { private declarations }
    function FormatResult(aValue: double): string;
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

uses
  mdconvutils, mdstdconvs, about;

function imax(a, b: integer): integer;
begin
  if a > b then result := a else result := b;
end;

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
  AssignFamilies(Measure_1.Items);
  AssignFamilies(Measure_3.Items);
  AssignFamilies(Measure_2.Items);
  AssignFamilies(Measure_4.Items);
  Measure_2.Items.insertobject(0, '<not used>', TObject(CIllegalConvFamily));
  Measure_4.Items.insertobject(0, '<not used>', TObject(CIllegalConvFamily));

  Measure_1.ItemIndex := 0;
  Measure_1Change(Measure_1);

  Measure_2.ItemIndex := 0;
  Measure_2Change(Measure_2);
end;

procedure TForm1.Edit1EditingDone(Sender: TObject);
var
  SourceValue: TConvUtilFloat;
  TargetValue: TConvUtilFloat;
  from1, from2: TConvType;
  to1, to2: TConvType;
begin
  try
    SourceValue := strtofloat(Edit1.Text);
    from1 := ptrInt(ConvType_1.Items.Objects[ConvType_1.ItemIndex]);
    if ConvType_2.ItemIndex < 0 then
      from2 := CIllegalConvType
    else
      from2 := ptrInt(ConvType_2.Items.Objects[ConvType_2.ItemIndex]);
    to1 := ptrInt(ConvType_3.Items.Objects[ConvType_3.ItemIndex]);
    if ConvType_4.ItemIndex < 0 then
      to2 := CIllegalConvType
    else
      to2 := ptrInt(ConvType_4.Items.Objects[ConvType_4.ItemIndex]);
    if (from2 = CIllegalConvType) then
      TargetValue := Convert(SourceValue, from1, to1)
    else
      TargetValue := Convert(SourceValue, from1, from2, to1, to2);
    Edit2.Text := FormatResult(TargetValue);
  except
    Edit2.Text := ''
  end;
end;

procedure TForm1.ConvType_1Change(Sender: TObject);
begin
  Edit1EditingDone(nil);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  close;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  TAboutForm.ShowForm;
end;

procedure TForm1.ConvType_3Change(Sender: TObject);
begin
  Edit2EditingDone(nil);
end;

procedure TForm1.Edit2EditingDone(Sender: TObject);
var
  SourceValue: TConvUtilFloat;
  TargetValue: TConvUtilFloat;
  from1, from2: TConvType;
  to1, to2: TConvType;
begin
  try
    SourceValue := strtofloat(Edit2.Text);
    from1 := ptrInt(ConvType_3.Items.Objects[ConvType_3.ItemIndex]);
    if ConvType_2.ItemIndex < 0 then
      from2 := CIllegalConvType
    else
      from2 := ptrInt(ConvType_4.Items.Objects[ConvType_4.ItemIndex]);
    to1 := ptrInt(ConvType_1.Items.Objects[ConvType_1.ItemIndex]);
    if ConvType_2.ItemIndex < 0 then
      to2 := CIllegalConvType
    else
      to2 := ptrInt(ConvType_2.Items.Objects[ConvType_2.ItemIndex]);
    if (from2 = CIllegalConvType) then
      TargetValue := Convert(SourceValue, from1, to1)
    else
      TargetValue := Convert(SourceValue, from1, from2, to1, to2);
    Edit1.Text := FormatResult(TargetValue);
  except
    Edit1.Text := ''
  end;
end;

function TForm1.FormatResult(aValue: double): string;
var
  s: string;
begin
  if cbDigitType.ItemIndex > 0 then
    s := '%.*f'
  else
    s := '%.*g';
  result := Format(s, [DecimalsSpin.Value, aValue]);
end;

procedure TForm1.Measure_1Change(Sender: TObject);
var
  n: integer;
begin
  n := imax(0, Measure_1.ItemIndex);
  AssignConvTypes(ptrint(Measure_1.Items.Objects[n]), ConvType_1.Items);
  ConvType_1.ItemIndex := 0;

  if assigned(Sender) then begin
    Measure_3.ItemIndex := n;
    Measure_3Change(nil);
    Edit1EditingDone(nil);
  end;
end;

procedure TForm1.Measure_2Change(Sender: TObject);
var
  n: integer;
begin
  n := imax(0, Measure_2.ItemIndex);
  AssignConvTypes(ptrint(Measure_2.Items.Objects[n]), ConvType_2.Items);
  ConvType_2.ItemIndex := 0;

  if assigned(Sender) then begin
    Measure_4.ItemIndex := n;
    Measure_4Change(nil);
    Edit1EditingDone(nil);
  end;
end;

procedure TForm1.Measure_3Change(Sender: TObject);
var
  n: integer;
begin
  n := imax(0, Measure_3.ItemIndex);
  AssignConvTypes(ptrint(Measure_3.Items.Objects[n]), ConvType_3.Items);
  ConvType_3.ItemIndex := 0;

  if assigned(Sender) then begin
    Measure_1.ItemIndex := n;
    Measure_1Change(nil);
    Edit2EditingDone(nil);
  end;
end;

procedure TForm1.Measure_4Change(Sender: TObject);
var
  n: integer;
begin
  n := imax(0, Measure_4.ItemIndex);
  AssignConvTypes(ptrint(Measure_4.Items.Objects[n]), ConvType_4.Items);
  ConvType_4.ItemIndex := 0;

  if assigned(Sender) then begin
    Measure_2.ItemIndex := n;
    Measure_2Change(nil);
    Edit2EditingDone(nil);
  end;
end;


end.

