unit Main;

{$mode objfpc}{$H+}

interface

uses
  LCLType,
  SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, Menus, Buttons, ExtCtrls,
  Spin, ActnList, StdActns, mdConvUtils, mdStdConvs;

type
  { TDemoForm }

  TDemoForm = class(TForm)
    acCopyAllConversions: TAction;
    acFileExit: TFileExit;
    acSaveAllConversions: TFileSaveAs;
    acAbout: TAction;
    acCopySingleConversion: TAction;
    ActionList1: TActionList;
    cbDigitType: TComboBox;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    UnitCombo: TComboBox;
    DecimalsSpin: TSpinEdit;
    Label3: TLabel;
    Label5: TLabel;
    MainMenu1: TMainMenu;
    MenuItem18: TMenuItem;
    MenuItem19: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    MenuItem6: TMenuItem;
    MenuItem7: TMenuItem;
    MenuItem8: TMenuItem;
    miListConstants2: TMenuItem;
    miListfunctions2: TMenuItem;
    miSymbols: TMenuItem;
    N10: TMenuItem;
    N11: TMenuItem;
    ResultBox: TListBox;
    miSaveConversions: TMenuItem;
    SourceUnitBox: TListBox;
    ConvTypes: TListBox;
    resultgrid: TStringGrid;
    ConversionPopupMenu: TPopupMenu;
    miSaveOneConversion: TMenuItem;
    miCopyConversions: TMenuItem;
    MeasureCombo: TComboBox;
    ValueEdit: TEdit;
    procedure acAboutExecute(Sender: TObject);
    procedure acCopyAllConversionsExecute(Sender: TObject);
    procedure acCopySingleConversionExecute(Sender: TObject);
    procedure acSaveAllConversionsAccept(Sender: TObject);
    procedure DecimalsSpinChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ResultBoxDblClick(Sender: TObject);
    procedure MeasureComboChange(Sender: TObject);
    procedure UnitComboChange(Sender: TObject);
    procedure ValueEditEditingDone(Sender: TObject);
    procedure ValueEditKeyPress(Sender: TObject; var Key: char);
  private
    { Private declarations }
    FConvFamilyArray: TConvFamilyArray; // all measurement families
    FConvTypeArray: TConvTypeArray;     // current family's conversion types
    FCurrentFamily: TConvFamily;
    FCurrentBase: TConvType;
    procedure SetCurrentBaseConversion(aValue: TConvType);
    function ConversionsAsStrings: string;
    function SelectedConversionAsString: string;
  public
    { Public declarations }
  end;

var
  DemoForm: TDemoForm;

implementation

{$R *.lfm}

uses
  Themes, Clipbrd, About;

function imax(a, b: integer): integer;
begin
  if a > b then result := a else result := b;
end;

procedure TDemoForm.acAboutExecute(Sender: TObject);
begin
  TAboutForm.ShowForm;
end;

procedure TDemoForm.acCopyAllConversionsExecute(Sender: TObject);
begin
  Clipboard.AsText := ConversionsAsStrings;
end;

procedure TDemoForm.acCopySingleConversionExecute(Sender: TObject);
begin
  Clipboard.AsText := SelectedConversionAsString;
end;

procedure TDemoForm.acSaveAllConversionsAccept(Sender: TObject);
var
  sl: TStrings;
begin
  sl := TStringList.Create;
  try
    sl.Text := ConversionsAsStrings;
    sl.SaveToFile(acSaveAllConversions.Dialog.FileName);
  finally
    sl.free;
  end;
end;

function TDemoForm.ConversionsAsStrings: string;
const
  eol = #13#10;
  firstsep = ' ';
  secondsep = ' ';
var
  i, n, p: integer;
  s: string;
begin
  n := ResultBox.ItemIndex;
  if n >= 0 then begin
    result := Format('%s %s = %s', [ValueEdit.Text, UnitCombo.Text, eol]);
  end
  else
    result := '';
  with ResultBox do begin
    for i := 0 to Items.Count-1 do
      if i <> n then begin
        s := ResultBox.Items[i];
        p := pos(' ', s);
        if p > 0 then begin
          delete(s, p, 1);
          insert(SecondSep, s, p);
        end;
        result := result + FirstSep + s + eol;
      end;
  end;
end;

procedure TDemoForm.DecimalsSpinChange(Sender: TObject);
begin
  ValueEditEditingDone(Sender);
end;

procedure TDemoForm.FormCreate(Sender: TObject);
var
  i: integer;
begin
  Constraints.MinHeight := height;
  Constraints.MinWidth := width;

  // Load all convert family descriptions into the
  // measurement combo box. Done only once.
  GetConvFamilies(FConvFamilyArray);
  MeasureCombo.Items.Clear;
  for i := 0 to length(FConvFamilyArray)-1 do
    MeasureCombo.Items.Add(ConvFamilyToDescription(FConvFamilyArray[i]));

  MeasureCombo.ItemIndex := 0;
  cbDigitType.ItemIndex := 0;

  // this will initiate the results list and
  // unit combo box
  FCurrentFamily := CIllegalConvFamily;
  MeasureComboChange(nil);
end;

procedure TDemoForm.MeasureComboChange(Sender: TObject);
var
  i: integer;
  nf: TConvFamily;
begin
  nf := FConvFamilyArray[imax(0, MeasureCombo.ItemIndex)];
  if FCurrentFamily <> nf then begin
    FCurrentFamily := nf;
    GetConvTypes(FCurrentFamily, FConvTypeArray);
    UnitCombo.Items.Clear;
    for i := 0 to length(FConvTypeArray)-1 do
      UnitCombo.Items.Add(ConvTypeToDescription(FConvTypeArray[i]));
    FCurrentBase := FConvTypeArray[0];
    ValueEditEditingDone(nil);
    UnitCombo.Text := ConvTypeToDescription(FCurrentBase);
  end;
end;

procedure TDemoForm.UnitComboChange(Sender: TObject);
begin
  SetCurrentBaseConversion(FConvTypeArray[imax(0, UnitCombo.ItemIndex)]);
end;

procedure TDemoForm.ResultBoxDblClick(Sender: TObject);
begin
  SetCurrentBaseConversion(FConvTypeArray[imax(0, ResultBox.ItemIndex)]);
end;

function TDemoForm.SelectedConversionAsString: string;
const
  firstsep = ' ';
  secondsep = ' ';
var
  n, p: integer;
  s: string;
begin
  result := Format('%s %s = ', [ValueEdit.Text, UnitCombo.Text]);
  n := ResultBox.ItemIndex;
  if n >= 0 then begin
    s := ResultBox.Items[n];
    p := pos(' ', s);
    if p > 0 then begin
      delete(s, p, 1);
      insert(SecondSep, s, p);
    end;
    result := result + FirstSep + s;
  end;
end;

procedure TDemoForm.SetCurrentBaseConversion(aValue: TConvType);
begin
  if aValue <> FCurrentBase then begin
    FCurrentBase := aValue;
    ValueEditEditingDone(nil);
    UnitCombo.Text := ConvTypeToDescription(FCurrentBase);
  end;
end;

procedure TDemoForm.ValueEditEditingDone(Sender: TObject);
var
  SourceValue, ConvertedValue: Double;
  s: string;
  i, resultBoxIndex: Integer;
  ToType: TConvType;
begin
  resultBoxIndex := imax(0, ResultBox.ItemIndex);
  ResultBox.Clear;
  try
    SourceValue := strtofloat(ValueEdit.Text);
  except
    SourceValue := 0;
    Raise;
  end;

  if cbDigitType.ItemIndex > 0 then
    s := '%.*f'
  else
    s := '%.*g';
  s := s + ' %s';
  for i := 0 to length(FConvTypeArray)-1 do begin
    toType := FConvTypeArray[i];
    ConvertedValue := Convert(SourceValue, FCurrentBase, toType);
    ResultBox.Items.add(Format(s, [DecimalsSpin.Value, ConvertedValue, ConvTypeToDescription(ToType)]));
  end;
  if resultBoxIndex >= ResultBox.Items.Count then
    resultBoxIndex := 0;
  ResultBox.ItemIndex := ResultBoxIndex;
end;

procedure TDemoForm.ValueEditKeyPress(Sender: TObject; var Key: char);
begin
  //
  // Do nothing with keys that are not aphanumeric
  // The only valid keys are '0'..'9', 'e', 'E',
  // '.' and the decimal separator and '+', '-'
  //
  if (key >= ' ') then with ValueEdit do begin
    if (key = '.') then
      key := DefaultFormatSettings.DecimalSeparator;
    if (upcase(Key) = 'E') then begin
      if ( (pos('e',Text) > 0) or (pos('E', Text) > 0) ) then begin
        key := #0;
      end
    end
    else if key = DefaultFormatSettings.DecimalSeparator then begin
      if pos(key, Text) > 0 then begin
        key := #0;
      end
    end
    else if (key = '-') or (key = '+') then begin
      if (SelStart > 0) and (upcase(Text[SelStart]) <> 'E') then begin
        key := #0;
      end;
    end
    else if (key < '0') or (key > '9') then begin
      key := #0;
    end;
    if key = #0 then
      sysutils.beep;
  end;
end;

end.
