unit main;

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Spin;

type

  { TForm1 }

  TForm1 = class(TForm)
    CheckBox1: TCheckBox;
    Label1: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Label13: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    seYear: TSpinEdit;
    seMonth: TSpinEdit;
    seDay: TSpinEdit;
    seHour: TSpinEdit;
    seMinute: TSpinEdit;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    seSecond: TSpinEdit;
    seMillisecond: TSpinEdit;
    Label12: TLabel;
    Button1: TButton;
    LinkLabel1: TLabel;
    procedure CheckBox1Change(Sender: TObject);
    procedure LinkLabel1Click(Sender: TObject);
    procedure seYearChange(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure Edit2Exit(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Edit3Exit(Sender: TObject);
  private
    { Dclarations prives }
    procedure DecodeDateTime(aDateTime: TDateTime; Dontchange: TEdit = nil);
    procedure UpdateEdits(aDateTime: TDateTime; Dontchange: TEdit = nil);
  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

uses
  LCLIntf, sysconst, dateutils;

{ The following 5 functions are fixed versions of functions found in
  Free Pascal DateUtils.pp that convert between the built-in TDateTime
  type of variable and Julian date and modified Julian date.

  The Free Pascal versions do not take into consideration fractions of
  days. For Delphi compatibility, conversion of TDateTime to Julian and
  modified Julian dates should include the fractions of days.

  Only minor changes to two functions in dateutil.inc

    function DateTimeToJulianDate(const aValue: TDateTime): double;
    function TryJulianDateTimeToDateTime(const AValue: Double; out ADateTime: TDateTime): Boolean;

  need to be done.
}

{ 'Fixed' version of dateutils.DateTimeToJulianDate. }
function DateTimeToJulianDateTime(const aValue: TDateTime): double;
var
  a, y, m: longint;
  year, month, day: word;
begin
  DecodeDate(aValue, year, month, day);
  a := (14 - month) div 12;
  y := year + 4800 - a;
  m := month + (12*a) - 3;
  result := day + ((153*m + 2) div 5) + (365*y)
    + (y div 4) - (y div 100) + (y div 400) - 32045.5
    + frac(avalue);
end;

{ 'Fixed' version of dateutils.TryJulianDateToDateTime }
function TryJulianDateTimeToDateTime(const AValue: Double; out ADateTime: TDateTime): Boolean;
var
  a,b,c,d,e,m:longint;
  day,month,year: word;
begin
  a := trunc(AValue + 32044.5);
  b := (4*a + 3) div 146097;
  c := a - (146097*b div 4);
  d := (4*c + 3) div 1461;
  e := c - (1461*d div 4);
  m := (5*e+2) div 153;
  day := e - ((153*m + 2) div 5) + 1;
  month := m + 3 - 12 *  ( m div 10 );
  year := (100*b) + d - 4800 + ( m div 10 );
  result := TryEncodeDate(Year, Month, Day, ADateTime);
  ADateTime := ADateTime + 0.5 + frac(aValue);
end;

{ 'Fixed' version of dateutils.JulianDateToDateTime. }
function JulianDateTimeToDateTime(const aValue: Double): TDateTime;
begin
  if not TryJulianDateTimeToDateTime(AValue, Result) then
     raise EConvertError.CreateFmt(SInvalidJulianDate, [AValue]);
end;

{ 'Fixed' version of dateutils.DateTimeToModifiedJulianDate. }
function DateTimeToModifiedJulianDateTime(const aValue: TDateTime): double;
begin
  result := DateTimeToJulianDateTime(aValue) - 2400000.5
end;

{ 'Fixed' version of dateutils.ModifiedJulianDateToDateTime }
Function ModifiedJulianDateTimeToDateTime(const AValue: Double): TDateTime;
begin
  result := JulianDateTimeToDateTime(AValue + 2400000.5);
end;


function FormatDateTime(aValue: double): string;
begin
  result := Format('%.6f', [aValue]);
end;

procedure TForm1.DecodeDateTime(aDateTime: TDateTime; Dontchange: TEdit);
var
  aYear, aMonth, aDay: word;
  aHour, aMinute, aSecond, aMillisecond: word;
begin
  DecodeDate(aDateTime, aYear, aMonth, aDay);
  DecodeTime(aDateTime, aHour, aMinute, aSecond, aMillisecond);
  seYear.Value := aYear;
  seMonth.Value := aMonth;
  seDay.Value := aDay;
  seHour.Value := aHour;
  seMinute.Value := aMinute;
  seSecond.Value := aSecond;
  seMillisecond.Value := aMillisecond;
  UpdateEdits(aDateTime, DontChange);
end;

procedure TForm1.UpdateEdits(aDateTime: TDateTime; DontChange: TEdit);
begin
  if Edit1 <> DontChange then
    Edit1.Text := FormatDateTime(aDateTime);
  if checkbox1.checked then begin
    if Edit2 <> DontChange then
      Edit2.Text := FormatDateTime(DateTimeToJulianDateTime(aDateTime));
    if Edit3 <> DontChange then
      Edit3.Text := FormatDateTime(DateTimeToModifiedJulianDateTime(aDateTime));
  end
  else begin
    if Edit2 <> DontChange then
      Edit2.Text := FormatDateTime(DateTimeToJulianDate(aDateTime));
    if Edit3 <> DontChange then
      Edit3.Text := FormatDateTime(DateTimeToModifiedJulianDate(aDateTime));
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  DecodeDateTime(now);
end;


procedure TForm1.Edit1Exit(Sender: TObject);
var
  aDateTime: TDateTime;
begin
  try
    aDateTime := strtofloat(Edit1.Text);
    DecodeDateTime(aDateTime, Edit1);
    Label12.Caption := '';
  except
    Label12.Caption := 'Invalid datetime';
    beep;
  end;
end;

procedure TForm1.Edit2Exit(Sender: TObject);
var
  aJulianDate: double;
  aDateTime: TDateTime;
begin
  try
    aJulianDate := strtofloat(Edit2.Text);
    if CheckBox1.checked then
      aDateTime := JulianDateTimeToDateTime(aJulianDate)
    else
      aDateTime := JulianDateToDateTime(aJulianDate);
    DecodeDateTime(aDateTime, Edit2);
    Label12.Caption := '';
  except
    Label12.Caption := 'Invalid Julian date';
    beep;
  end;
end;

procedure TForm1.Edit3Exit(Sender: TObject);
var
  aModifiedJulianDate: double;
  aDateTime: TDateTime;
begin
  try
    aModifiedJulianDate := strtofloat(Edit3.Text);
    if CheckBox1.checked then
      aDateTime := ModifiedJulianDateTimeToDateTime(aModifiedJulianDate)
    else
      aDateTime := ModifiedJulianDateToDateTime(aModifiedJulianDate);
    DecodeDateTime(aDateTime, Edit3);
    Label12.Caption := '';
  except
    Label12.Caption := 'Invalid ModifiedJulian date';
    beep;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Button1Click(nil);
end;

procedure TForm1.seYearChange(Sender: TObject);
var
  aDateTime: TDateTime;
begin
  aDateTime :=
    EncodeDate(seYear.Value, seMonth.Value, seDay.Value) +
    EncodeTime(seHour.Value, seMinute.Value,
      seSecond.Value, seMillisecond.Value);
  UpdateEdits(aDateTime);
end;

procedure TForm1.LinkLabel1Click(Sender: TObject);
begin
  OpenURL(LinkLabel1.Hint)
end;

procedure TForm1.CheckBox1Change(Sender: TObject);
begin
  seYearChange(nil);
end;

end.
