#include <ESP8266Ping.h>
#include "monitor.h"
#include "support.h"
#include "monitor.h"

int pingTarget = 0;


// timers
unsigned long lastTimeWifiUp;
unsigned long lastTimeInternetReached;
unsigned long lastPingTime;


netResult_t testNetwork(void) { 
  if (WiFi.status() != WL_CONNECTED) {
    if (millis() - lastTimeWifiUp > config.wifiDownInterval) {
      sendToLogP(LOG_ERR, PSTR("*** WiFi DOWN ***"));
      return WIFI_DOWN;
    } else {  
      // wifi may down but wait before declaring it so
      // No use trying pinging
      return NET_OK;
    }  
  } else {
    // WiFi is up, reset the timer
    lastTimeWifiUp = millis();
  }

  if (millis() - lastPingTime < config.intervalBetweenPings) {
    if (millis() - lastTimeInternetReached > config.internetLostInterval) {
      sendToLogP(LOG_DEBUG, PSTR("*** INTERNET LOST ***"));
      return INTERNET_UNREACHABLE;    
    } 
    return NET_OK;
  }
  
  lastPingTime = millis();
  if (Ping.ping(config.targets[pingTarget], 1)) { 
    sendToLogPf(LOG_INFO, PSTR("Pinged %s with success"), config.targets[pingTarget]);
    lastTimeInternetReached = millis();
  } else {
    sendToLogPf(LOG_INFO, PSTR("Failed pinging %s"), config.targets[pingTarget]);
  }   
  pingTarget = (++pingTarget) % PING_TARGET_COUNT;
  return NET_OK;
}

unsigned long cycleStartTime;
unsigned long spinInterval;
unsigned long spinStartTime;

/*
void reportMonitorState(void) {
  int index = (monitorState != SPINNING) ? monitorState : (isWifiDown) ? monitorState : monitorState+1;
  sendToLog(LOG_INFO, monitorStateString[index]); 
}  
*/

void disableMonitor(void) {
  monitorState = DISABLED;
  int pattern = (isRouterOn()) ? ROUTER_ON_PATTERN : ROUTER_OFF_PATTERN;
  setBlinkyPattern(pattern);  
  sendToLogP(LOG_DEBUG, PSTR("Disable monitoring"));
}

void enableMonitor(void) {
  monitorState = MONITORING;
  setBlinkyPattern(HEARTBEAT_PATTERN);
  lastTimeWifiUp = millis();
  lastTimeInternetReached = millis();
  lastPingTime = millis();
  sendToLogP(LOG_DEBUG, PSTR("Enable monitoring"));
}

/*
void toggleMonitor(void) {
  if (monitorState == DISABLED) {
    enableMonitor();
  } else {
    disableMonitor();
  }
}
*/
void startCycling(unsigned long len) {
  netDownReason = WIFI_DOWN;
  monitorState = CYCLING;
  setRouterOff();
  setBlinkyPattern(ROUTER_CYCLING_PATTERN);
  spinInterval = (len) ? len : config.waitAfterWifiDown;
  cycleStartTime = millis();
}
void startSpinning(void) {
  monitorState = SPINNING;
  setBlinkyPattern(WAIT_PATTERN);
  spinStartTime = millis();
  spinInterval = config.waitAfterWifiDown;
}

void monitorUpdate(void) {

  if (monitorState == DISABLED) return;

  if (monitorState == MONITORING) {
    switch (testNetwork()) {
      case WIFI_DOWN: { netDownReason = WIFI_DOWN; monitorState = CYCLING; } break;
      case INTERNET_UNREACHABLE: { netDownReason = INTERNET_UNREACHABLE; monitorState = CYCLING; } break;
    }
    if (monitorState == CYCLING) {
      setRouterOff();
      setBlinkyPattern(ROUTER_CYCLING_PATTERN);
      spinInterval = (netDownReason == WIFI_DOWN) ? config.waitAfterWifiDown : config.waitAfterInternetLost;
      cycleStartTime = millis();
    }
    return;
  }  

  if (monitorState == CYCLING) {
    if (millis() - cycleStartTime >= config.routerOffInterval) {
      setRouterOn();
      setBlinkyPattern(WAIT_PATTERN);
      monitorState = SPINNING;
      spinStartTime = millis();
    }
  }

  if (monitorState == SPINNING) {
    if (millis() - spinStartTime >= spinInterval) {
      enableMonitor();
     }
  }
}


    
