(***********************************************************************
 *
 * ParserTypes version 1.0
 *
 * Copyright (c) 2013 Michel Deslierres
 * All rights reserved. Tous droits rservs.
 *
 * Read full license in the file license.txt
 * Lire la licence au complet dans le fichier license.txt
 *
 ************************************************************************)
 
{: Unit that contains global types that are used by other units in
   the project. See ParserConsts.pas for string constants.}
Unit ParserTypes;

interface

type
  float = extended;

  {: Errors that the mathematical expression parser may report.}
  TParserError = (
    {: Never returned by parser}
    peNoError,

    {: Unexpected end of string when expecting a factor (in module factor).
       This error will be raised when parsing "5 +" because a
       factor should follow the + sign.}
    peUnexpectedEOS,

    {: Expected the end of the expression, found something extraneous.
       This error occurs when parsing the final number in the expression
       "5 + 8 32".}
    peExpectedEOS,

    {: An invalid number was found. This occurs in the Factor routine
       when parsing an expression such as "5,3E*8" where the "E" must
       be followed by a valid positive or negative integer.}
    peInvalidNumber,

    {: Found an unknown or invalid operator when parsing a factor.
       This errors occurs when parsing the multiply operator in the
       expression "5 + *" or when parsing the unknown operator "!"
       in the expression "5 + !".}
    peUnexpectedElement,

    {: Expected a ")" to mark the end of a function call or to mark the
       end of an expression that started with a "(". This error occurs
       in the procedure Builtin when parsing the expressions "sin(5 + 8"
       and "sin(5, 8)"  and in the procedure Factor when parsing a factor
       of the form "( expression )" with a missing right paranthesis as
       in the expression "5*(2 + 3".}
    peExpectedRightPar);


implementation

end.
