(***********************************************************************
 *
 * ParserConsts version 1.0
 *
 * Copyright (c) 2013 Michel Deslierres
 * All rights reserved. Tous droits rservs.
 *
 * Read full license in the file license.txt
 * Lire la licence au complet dans le fichier license.txt
 *
 ************************************************************************)
 
{: Unit with string contants for parser.}
 unit ParserConsts;

{$IFNDEF PARSER_INC}
  {$I Parser.inc}
{$ENDIF}

interface

uses
  ParserTypes;
  
{$IFDEF HAS_RESOURCESTRING}  
resourcestring
{$ELSE}
const
{$ENDIF}
  SParseError = 'Math parser error';

  {Preparation for internationalization using dxgettext}
function _(const value: string): string;
  
  {Returns an errror message based on the specified TParserError. The
   parser's list char must also be given.}
function ParseMessage(value: TParserError): string;

implementation

uses
  SysUtils;

function _(const value: string): string;
begin
  result := value;
end;

function ParseMessage(value: TParserError): string;
begin
  case value of
    peNoError:  result := _('no parser error');
    peUnexpectedEOS: result := _('unexpected end of source');
    peExpectedEOS: result := _('expected end of source');
    peInvalidNumber: result := _('invalid number');
    peUnexpectedElement: result := _('unexpected element');
    peExpectedRightPar: result := _('expected ")"');
  else
    result := Format('unknown error #%d' , [ord(value)])
  end;
end;

end.
