unit ParserInfo;

interface

{$IFNDEF PARSER_INC}
  {$I ..\Parser.inc}
{$ENDIF}

{.DEFINE VERSION1}     { define for MathParser, undefine for SimpleMathParser }
{.DEFINE WITH_TARGETS} { define when Targets.pas included}
{.DEFINE WITH_PARSERLISTCHAR}

uses
  SysUtils, Classes;

procedure GetParserInfo(strings: TStrings);

implementation

uses
  {$IFDEF WITH_TARGETS} Targets, {$ENDIF}
  {$IFDEF VERSION_1} MathParser {$ELSE} SimpleMathParser {$ENDIF};


const
  snoyes: array[boolean] of string = ('no', 'yes');


procedure GetParserInfo(strings: TStrings);
var
  s, ss: string;
begin
  strings.Clear;
  strings.Add('Version: ' + SVersionName + ' ' + SVersion);

  {$IFDEF WITH_TARGETS}
  s := 'Case sensitive: ';
  try
    InternalTargets.Add('PI', TConstant.create(0));
    ss := snoyes[true];
    InternalTargets.Delete('PI');
  except
    ss := snoyes[false];
  end;
  strings.add(s + ss);
  {$ENDIF}

  strings.add('System decimal symbol: ' + DecimalSeparator);
  strings.add('Parser decimal symbol: ' + ParserDecimalChar);

   s := 'HAS_LISTSEPERATOR defined: ';
  {$IFDEF HAS_LISTSEPARATOR}
    ss := snoyes[true];
  {$ELSE}
    ss := snoyes[false];
  {$ENDIF}
  strings.add(s + ss);

  {$IFDEF HAS_LISTSEPARATOR}
  strings.add('System list separator: ' + listseparator);
  {$ELSE}
  strings.Add('System list separator: <none> presumably');
  {$ENDIF}

  {$IFDEF WITH_PARSERLISTCHAR}
  strings.add('Parser list separator: ' + ParserListChar);
  {$ENDIF}

  s := 'HAS_SYSCONST defined: ';
  {$IFDEF HAS_SYSCONST}
    ss := snoyes[true];
  {$ELSE}
    ss := snoyes[false];
  {$ENDIF}
  strings.add(s + ss);

  s := 'USE_MATH_UNIT defined: ';
  {$IFDEF USE_MATH_UNIT}
    ss := snoyes[true];
  {$ELSE}
    ss := snoyes[false];
  {$ENDIF}
  strings.add(s + ss);

  {$IFDEF USE_MATH_UNIT}
    s := 'FIX_ARCCSH defined: ';
    {$IFDEF FIX_ARCCSCH}
      ss := snoyes[true];
    {$ELSE}
      ss := snoyes[false];
     {$ENDIF}
     strings.add(s + ss);
  {$ENDIF}

  s := 'DELPHI_DIV_MOD defined: ';
  {$IFDEF DELPHI_DIV_MOD}
    ss := snoyes[true];
  {$ELSE}
    ss := snoyes[false];
  {$ENDIF}
  strings.add(s + ss);

  s := 'EXPONENT_RIGHT_ASSOCIATIVE defined: ';
  {$IFDEF EXPONENT_RIGHT_ASSOCIATIVE}
    ss := snoyes[true];
  {$ELSE}
    ss := snoyes[false];
  {$ENDIF}
  strings.add(s + ss);

  s := 'HAS_RESOURCESTRING defined: ';
  {$IFDEF HAS_RESOURCESTRING}
    ss := snoyes[true];
  {$ELSE}
    ss := snoyes[false];
  {$ENDIF}
  strings.add(s + ss);

  s := 'DUMP defined: ';
  {$IFDEF DUMP}
    ss := snoyes[true];
  {$ELSE}
    ss := snoyes[false];
  {$ENDIF}
  strings.add(s + ss);
end;

end.
