unit Main;

{$I ..\Parser.inc}
{$I ..\Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TMainForm = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    QuitButton: TButton;
    Button3: TButton;
    OptionsButton: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure QuitButtonClick(Sender: TObject);
    procedure Button1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure OptionsButtonClick(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
  private
    { Dclarations prives }
    {$IFNDEF HAS_ANCHORS}
    FMinWidth: integer;
    {$ENDIF}
    procedure ClearResult;
  public
    { Dclarations publiques }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

uses
  ParserTypes, ParserConsts, SimpleMathParser, ShowTree,
  Options;

procedure TMainForm.Button1Click(Sender: TObject);
var
  value: float;
begin
  Edit1.SetFocus;
  try
    value := EvaluateExpression(Edit1.Text);
    label1.Caption := floattostr(value);
  except
    On E: EMathParserErr do begin
      Edit1.SelStart := E.TokenStart - 1;
      Edit1.SelLength := E.TokenLength;
      label1.Caption := Format('Parse Error: %s',
        [ParseMessage(E.ParserError)])
    end;
    On E: Exception do
      label1.Caption := Format('Evaluation Error: (%s) %s',[E.ClassName, E.message]);
  end;
end;

procedure TMainForm.Button1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  ClearResult;
end;

procedure TMainForm.QuitButtonClick(Sender: TObject);
begin
  Close
end;

procedure TMainForm.Button3Click(Sender: TObject);
begin
  {$IFDEF DUMP}
  with ParseTreeForm do begin
    Memo1.Lines.Clear;
    Memo1.Lines.Assign(journal);
    showmodal;
  end;
  {$ELSE}
  MessageDlg('Compiler directive  DUMP not defined. See Parser.inc', mtInformation, [mbOK], 0);
  {$ENDIF}
end;

procedure TMainForm.ClearResult;
begin
  Label1.Caption := ' Copyright 2013, 2014 Michel Deslierres'
end;

procedure TMainForm.Edit1Change(Sender: TObject);
begin
  ClearResult;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  {$IFDEF DUMP}
  Caption := 'DEMO: ' +  SVersionName + ' ' + SVersion;
  {$ENDIF}
  ClearResult;
  {$IFDEF HAS_ANCHORS}
  ClientWidth := Edit1.Width + 2*Edit1.Left;
  label1.Width := Edit1.Width - label1.Left + Edit1.left;
  Edit1.Anchors := [akLeft, akTop, akRight];
  Label1.Anchors :=  [akLeft, akTop, akRight];
  OptionsButton.Anchors := [akTop, akRight];
  QuitButton.Anchors := [akTop, akRight];
  Constraints.MaxHeight := Height;
  Constraints.MinHeight := Height;
  Constraints.MinWidth := Width;
  {$ELSE}
  FMinWidth := Width;
  {$ENDIF}
end;

procedure TMainForm.FormResize(Sender: TObject);
begin
  {$IFNDEF HAS_ANCHORS}
  Edit1.Width := ClientWidth - 2*Edit1.Left;
  Label1.Width := Edit1.Width - label1.Left + Edit1.left;
  QuitButton.Left := ClientWidth - QuitButton.Width - Edit1.left;
  OptionsButton.Left := QuitButton.Left - OptionsButton.Width - Edit1.left;
  ClientHeight := QuitButton.Height + QuitButton.Top + 10;
  if Width < FMinWidth then
    Width := FMinWidth;
  {$ENDIF}
end;

procedure TMainForm.OptionsButtonClick(Sender: TObject);
begin
  OptionsForm.ShowModal;
end;

procedure TMainForm.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then begin
    Button1Click(Button1);
    Key := #0;
  end;
end;

end.
