/*
 blink for Sipeed Longan Nano a GigaBit RISC-V GD32VF103CBT6 based board.

 Turns an LED on and off for multiple short periods and then off for a longer period. 
 This action is continuously repeated.

 Based on the example Blink.ino sketch in Arduino by Scott Fitzgerald, Arturo Guadalupi
 and Colby Newman

 March 29, 2020 Michel Deslierres <https://sigmdel.ca/michel>

 This example code is in the public domain.
*/ 

#include <Arduino.h>       

#define CYCLES 2           // 2 yields a heartbeat effect
#define SHORT_DELAY  50   // 1/10 second
#define LONG_DELAY  1000   // 1 second

// the setup function runs once when you press reset or power the board
void setup() {
   // initialize digital pin LED_BUILTIN as an output.
  pinMode(LED_BUILTIN, OUTPUT);
}

// the loop function runs over and over again forever
void loop() {
  for (int i=0; i<CYCLES; i++) {
    digitalWrite(LED_BUILTIN, LOW);    // turn the red LED on (it is active when the pin is LOW)
    delay(SHORT_DELAY);                // wait for a short on period
    digitalWrite(LED_BUILTIN, HIGH);   // turn the red LED off (by setting the active LOW pin HIGH)
    delay(SHORT_DELAY);                // wait for a short off period
  }    
  digitalWrite(LED_BUILTIN, HIGH);     // turn the LED off
  delay(LONG_DELAY);                   // wait for a long off period
}
