/*
 * blinks
 * Quickly flashes LED on for a number of times and then off for a longer period.
 *
 * ini.hpp must define the following directives
 *   LED_BUILTIN <gpio_pin_number>     GPIO to which the LED that will be flashed (could be defined in board's definition)
 *   LED_ON      <1 | HIGH | 0 | LOW>  Signal level that turns the LED on
 *
 * Copyright (C) 2021 Michel Deslierres
 */
/* SPDX-License-Identifier: 0BSD */
/* SPDX-URL: https://spdx.org/licenses/0BSD.html */

// WARNING! Select development card in ini.hpp
//
#include "ini.hpp"

//parameters that can be adjusted :

#define CYCLES        3  // number of consecutive flashes (on-off cycles) in each burst
#define FLASH_TIME  100  // period of LED on then off time (in ms) per flash in the burst
#define OFF_TIME   1900  // period of time (in ms) the LED is off between bursts

//do not change this
#define LED_OFF 1-LED_ON

void setup()
{
  Serial.begin(BAUD);
  // wait up to 3 seconds for serial device to come up
  while (!Serial && millis() < 3000) delay(10);
  // initialize LED digital pin as an output.
  pinMode(LED_BUILTIN, OUTPUT);
  Serial.println("\n");
  Serial.println("Blink");
  Serial.print("LED_BUILTIN (");
  Serial.print(LED_BUILTIN);
  Serial.println(") set to OUTPUT.");
  Serial.print("The LED is turned on by writing ");
  Serial.print((LED_ON) ? "HIGH" : "LOW");
  Serial.println(" to the pin.");
  Serial.println("Blink setup() completed.");
  Serial.println("Starting loop().\n");
}

void loop() {
  for (int i=0; i<CYCLES; i++) {
    digitalWrite(LED_BUILTIN, LED_ON);
    Serial.print("On, ");
    delay(FLASH_TIME);
    digitalWrite(LED_BUILTIN, LED_OFF);
    delay(FLASH_TIME);
  }
  Serial.println("OFF...");
  delay(OFF_TIME);
}
